/************************************************************************
* COPYRIGHT:   Copyright  2001 Symbol Technologies, Inc.
*
* FILE:        S24Defines.h
*
*************************************************************************/
#pragma once

#define S24_MAC_ADDR_LENGTH     6                   // 48 bit MAC/IEEE address
#define S24_BSS_ID_LENGTH       S24_MAC_ADDR_LENGTH
#define S24_ESS_ID_LENGTH       32                  // ESS ID length
#define S24_MKK_CALLSIGN_LEN    15                  // MKK Callsign length
#define S24_COUNTRY_TEXT_LEN    34                  // Country Text length
#define S24_VER_STRING_LEN      20                  // Version string length
#define S24_HOST_NAME_LEN       40                  // Host name length
#define S24_DOMAIN_NAME_LEN     40                  // Domain name length

#define netIFCreatorS24         's24i'              // Creator ID of the S24 network interface
#define netIFInstanceS24        0                   // Instance of the S24 network interface

// S24 Network Interface Settings
typedef enum
{
    netIFSettingS24Device = netIFSettingCustom,     // Is this an S24 device? (read only)
    netIFSettingS24EssID,                           // Adapter's ESS ID
    netIFSettingS24AccessPointBSSID,                // AP's BSSID (read only)
    netIFSettingS24DriverVersion,                   // Driver version (read only)
    netIFSettingS24AssociationStatus,               // Association status (read only)
    netIFSettingS24MKKCallsign,                     // MKK callsign (read only)
    netIFSettingS24CountryText,                     // Country text (read only)
    netIFSettingS24FirmwareVersion,                 // Firmware version (read only)
    netIFSettingS24FirmwareDate,                    // Firmware date (read only)
    netIFSettingS24Preferences                      // S24 Preferences
} s24NetIFSettings;

// S24 Preferences used by netIFSettingS24Preferences
// They are also changeable in the S24 Preferences Panel
typedef enum
{
    s24PrefESSID = 0x1000,                          // ESS ID to use when associating
    s24PrefShowESSID,                               // Show ESS ID string on association screen?
    s24PrefUseDHCP,                                 // Shall we use DHCP?
    s24PrefEnableDNS,                               // Enable DNS?
    s24PrefStaticIP,                                // Static IP of the S24 Device
    s24PrefSubnetMask,                              // Subnet mask for the S24 Device
    s24PrefGateway,                                 // Gateway used by the S24 Device
    s24PrefPrimaryDNS,                              // Primary DNS used by the S24 Device
    s24PrefSecondaryDNS,                            // Secondary DNS used by the S24 Device
    s24PrefHostName,                                // Host name of the S24 device
    s24PrefDomainName                               // Domain name of the S24 device
} s24Preferences;
